/*
 ͻ
                                                                           
                      Copyright (c) 1996 Aldo Ferraro                      
                            All Rights Reserved                            
                                                                           
 Ķ
                                                                           
   Source File :  MOUSE.CPP                                                
                                                                           
   Functions   :  1. detect_mouse       -  detect/initialize mouse         
                  2. mouse_switch       -  switch mouse cursor on/off      
                  3. get_mouse_xy       -  get mouse coordinates           
                  4. set_mouse_xy       -  set mouse coordinates           
                  5. get_mouse_press    -  get mouse button press info     
                  6. get_mouse_release  -  detect mouse button release     
                  7. set_mouse_range    -  set mouse screen area range     
                  8. set_graphic_mouse  -  define mouse graphic cursor     
                  9. set_text_mouse     -  define mouse text cursor        
                 10. get_mouse_movement -  determine mouse motion distance 
  NOT TESTED --> 11. set_mouse_handler  -  set mouse event handler         
  NOT TESTED --> 12. mouse_light_pen    -  enable/disable pen emulation    
                 13. set_mouse_speed    -  set mouse pointer speed         
                 14. set_mouse_area     -  set mouse cursor exclusion area 
                 15. set_mouse_threshold-  set max threshold for doubling  
  NOT TESTED --> 16. swap_mouse_handler -  swap user mouse event handler   
                 17. mouse_buffer_size  -  get mouse save buffer size      
  NOT TESTED --> 18. mouse_state        -  save/restore state or set alter 
  NOT TESTED --> 19. get_mouse_handler  -  get addr of alt mouse handler   
                 20. set_mouse_touch    -  set mouse sensitivity           
                 21. get_mouse_touch    -  get mouse sensitivity           
  NOT TESTED --> 22. set_mouse_int_rate -  set mouse hardware int rate     
                 23. set_mouse_page     -  set mouse display page          
                 24. get_mouse_page     -  get current page for mouse      
  NOT TESTED --> 25. disable_mouse      -  disable mouse driver            
  NOT TESTED --> 26. enable_mouse       -  enable mouse driver             
                 27. reset_mouse        -  mouse driver software reset     
                                                                           
   Description :  As specifically described for each function - see code.  
                                                                           
   Compiler    :  Borland C++ version 3.1                                  
                                                                           
   Compilation :  MOUSE.CPP, MOUSE.H                                       
                                                                           
   Author Name :  Aldo Ferraro                                             
                                                                           
   Address     :  19 Munro Close, Swindon, Wiltshire, England SN3 1BF      
                                                                           
   Developed on:  10 June 1996 - version 1.00.                             
                                                                           
   Last Update :  17 July 1996 - version 1.01.                             
                                                                           
 ͼ

 ͻ
   ATTENTION:---> Define Conditional Compilation Directives <--:ATTENTION  
 Ķ
  To include any desired function in your application,   you must set the  
  defined constant for that function to non-zero,  else the function will  
  not be linked to your application.                                       
                                                                           
  The required definitions for each function can be located in the header  
  file.  Further, the defined conditional directives are only required by  
  the linker, and are used to avoid linking functions not required.  Once  
  defined, and linked,  the C/CPP function will undefine those constants.  
 ͼ

 ͻ
                      Preprocessor #include Directives                     
 ͼ
*/

#include "mouse.h"

/*
 ͻ
                                Detect Mouse                               
 Ķ
                                                                           
   Function    :  Determine whether mouse driver installed, and number of  
                  buttons available. This is achieved by initializing the  
                  mouse driver.  If initialization fails, a value of 0 is  
                  returned in AX.  On success, the mouse driver returns a  
                  value of 0FFFFh in AX,  and assigns an initial value of  
                  -1  to the mouse cursor flag indicating no mouse cursor  
                  be displayed.                                            
                                                                           
                  Calling this function resets numerous mouse parameters   
                  to their default values, and moves the mouse cursor to   
                  the centre of the screen.  The screen and cursor masks   
                  are defined as an inverse video rectangle,  and  video   
                  page 0 is selected as the default page where the mouse   
                  cursor will be displayed when called.                    
                                                                           
                  If a mouse driver detected, the information returned in  
                  BX becomes relevant as it  returns  the number of mouse  
                  buttons available.                                       
                                                                           
                  Note: a program should call this function before calling 
                  any other mouse functions.                               
                                                                           
   Prototype   :  int detect_mouse(void)                                   
                                                                           
   Entry       :  void                                                     
                                                                           
   Return      :  int    =   number of available mouse buttons or FALSE    
                                                                           
 ͼ
*/

#if __DETECT_MOUSE

int detect_mouse(void)
{
  union REGS outreg;

  outreg.x.ax = 0x00;
  int86(0x33, &outreg, &outreg);
  return (outreg.x.ax ? outreg.x.bx : 0);
}

#endif

/*
 ͻ
                                Mouse Switch                               
 Ķ
                                                                           
   Function    :  This function  enables  you to turn the mouse cursor on  
                  or off. A value of 1 turns the mouse cursor on, and any  
                  other value will turn the mouse cursor off.              
                                                                           
                  Note: the mouse driver follows any mouse movement; even  
                  when the mouse cursor has been disabled.  Further, note  
                  that if calling this  function  twice  in succession to  
                  disable the mouse cursor,  you  must call this function  
                  twice in succession to enable the mouse cursor in order  
                  to maintain the proper sequence.                         
                                                                           
   Prototype   :  void mouse_switch(int mouse_on_off)                      
                                                                           
   Entry       :  mouse_on_off   =   1      show mouse pointer             
                  mouse_on_off  NOT  1      hide mouse pointer             
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __MOUSE_SWITCH

void mouse_switch(int mouse_on_off)
{
  union REGS inreg;

  inreg.x.ax = mouse_on_off == 1  ? 0x01 : 0x02;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                            Get Mouse Position                             
 Ķ
                                                                           
   Function    :  Determine mouse pointer position and status. On return   
                  the following information becomes available:             
                                                                           
                  &button  = button status, where bit 0, 1 and 2 indicate  
                             left,  right and centre buttons accordingly.  
                             If a button is pressed the bit is set.        
                                                                           
                  &mouse_x = horizontal mouse cursor position.             
                                                                           
                  &mouse_y = vertical mouse cursor position.               
                                                                           
   Note        :  The button status does not affect the tracking of mouse  
                  movements.                                               
                                                                           
                  All coordinates must be relative to the virtual screen.  
                  Text coordinates must be in multiples of 8 before being  
                  passed to this function,  and the  coordinates  must be  
                  located within the designated screen area.               
                                                                           
                  The  detect_mouse() function sets the complete range of  
                  mouse cursor to the entire screen area. Hence, to limit  
                  screen area, use the set_mouse_range function to define  
                  a smaller screen area.                                   
                                                                           
   Prototype   :  void get_mouse_xy(int &mouse_x, int &mouse_y, int &but)  
                                                                           
   Entry       :  mouse_x  =  column position of mouse cursor              
                  mouse_y  =  row position of mouse cursor                 
                  button   =  button status                                
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __GET_MOUSE_XY

void get_mouse_xy(int &mouse_x, int &mouse_y, int &button)
{
  union REGS outreg;

  outreg.x.ax = 0x03;
  int86(0x33, &outreg, &outreg);
  mouse_x = outreg.x.cx;
  mouse_y = outreg.x.dx;
  button = outreg.x.bx;
}

#endif

/*
 ͻ
                            Set Mouse Position                             
 Ķ
                                                                           
   Function    :  Set mouse pointer to specified coordinates. The values   
                  specified must fall within the column/row ranges being   
                  set.  In text mode,  the values are rounded off to the   
                  nearest permitted values.                                
                                                                           
   Prototype   :  void set_mouse_xy(int mouse_x, int mouse_y)              
                                                                           
   Entry       :  mouse_x   =   desired mouse column position              
                  mouse_y   =   desired mouse row position                 
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_XY

void set_mouse_xy(int mouse_x, int mouse_y)
{
  union REGS inreg;

  inreg.x.ax = 0x04;
  inreg.x.cx = mouse_x;
  inreg.x.dx = mouse_y;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                      Get Mouse Button Press Information                   
 Ķ
                                                                           
   Function    :  Get location where specified mouse button was pressed,   
                  and return button status & number of times pressed.      
                                                                           
   Note        :  The mouse (x, y) cordinates are only updated when the    
                  specified button pressed occurred, and sets the press    
                  counter to zero after the call.                          
                                                                           
   Prototype   :  int get_mouse_press(int &mouse_x, int &mouse_y,          
                                      int &count, int button)              
                                                                           
   Entry       :  &mouse_x  =  column position of mouse cursor             
                  &mouse_y  =  row position of mouse cursor                
                  &count    =  number of times button pressed              
                  button    =  desired mouse button to check               
                                                                           
   Return      :  int       =  status of requested button checked          
                                                                           
 ͼ
*/

#if __GET_MOUSE_PRESS

int get_mouse_press(int &mouse_x, int &mouse_y, int &count, int button)
{
  union REGS outreg;

  outreg.x.ax = 0x05;
  outreg.x.bx = button;                 // button to check
  int86(0x33, &outreg, &outreg);
  mouse_x = outreg.x.cx;
  mouse_y = outreg.x.dx;
  count = outreg.x.bx;                 // number of times button pressed
  return (outreg.x.ax);			// return button status
}

#endif

/*
 ͻ
                     Get Mouse Button Release Information                  
 Ķ
                                                                           
   Function    :  Determine location where the specified mouse button was  
                  released, read status of the specified mouse button and  
                  get number of releases.                                  
                                                                           
   Prototype   :  char get_mouse_release(int &mouse_x, int &mouse_y,       
                                         int &count, int button)           
                                                                           
   Entry       :  &mouse_x  =  column position of mouse cursor             
                  &mouse_y  =  row position of mouse cursor                
                  &count    =  number of times button released             
                  button    =  desired mouse button to check               
                                                                           
   Return      :  int       =  status of requested button checked          
                                                                           
 ͼ
*/

#if __GET_MOUSE_RELEASE

int get_mouse_release(int &mouse_x, int &mouse_y, int &count, int button)
{
  union REGS outreg;

  outreg.x.ax = 0x06;
  outreg.x.bx = button;			// button to check
  int86(0x33, &outreg, &outreg);
  mouse_x = outreg.x.cx;
  mouse_y = outreg.x.dx;
  count = outreg.x.bx;                  // number of times button pressed
  return (outreg.x.ax);                 // return button status
}

#endif

/*
 ͻ
                 Set Mouse Horizontal/Vertical Boundary Range              
 Ķ
                                                                           
   Function    :  Define mouse cursor horizontal/vertical boudary range.   
                                                                           
   Notes       :  If mouse  cursor  was outside  specified range prior to  
                  function call, the mouse driver will automatically move  
                  the mouse cursor within the specified range.             
                                                                           
                  If minimum > maximum value the function swaps values.    
                                                                           
                  A user cannot move the  mouse cursor  outside the range  
                  specified.                                               
                                                                           
   Prototype   :  void set_mouse_range(int mouse_x, int mouse_y,           
                                       int mouse_x2, int mouse_y2)         
                                                                           
   Entry       :  mouse_x  =  minimum horizontal mouse coordinate          
                  mouse_x2 =  maximum horizontal mouse coordinate          
                  mouse_y  =  minimum vertical mouse coordinate            
                  mouse_y2 =  maximum vertical mouse coordinate            
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_RANGE

void set_mouse_range(int mouse_x, int mouse_y, int mouse_x2, int mouse_y2)
{
  union REGS inreg;

  inreg.x.ax = 0x07;                   // set mouse vertical range
  inreg.x.cx = mouse_y;
  inreg.x.dx = mouse_y2;
  int86(0x33, &inreg, &inreg);

  inreg.x.ax = 0x08;   			// set mouse horizontal range
  inreg.x.cx = mouse_x;
  inreg.x.dx = mouse_x2;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                         Define Mouse Graphic Cursor                       
 Ķ
                                                                           
   Function    :  Redefine graphic mouse cursor. This function can only    
                  define the mouse cursor in graphics mode.  Before you    
                  make the call you must define the binary bit position    
                  for the mask[] array. The first 16 bit values for the    
                  mask[] array defines your screen mask.  The second 16    
                  bit values defines  the cursor mask.  Both the screen    
                  and cursor masks must reside in contiguous memory, so    
                  they only require using single array values.             
                                                                           
   Prototype   :  void set_graphic_mouse(int hotspot_x, int hotspot_y,     
                                         int *mask)                        
                                                                           
   Entry       :  hotspot_x  =  mouse cursor column hotspot                
                  hotspot_y  =  mouse cursor row hotspot                   
                  mask       =  pointer to mask[] array                    
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_GRAPHIC_MOUSE

void set_graphic_mouse(int hotspot_x, int hotspot_y, int *mask)
{
  union REGS inreg;
  struct SREGS segment_reg;

  segment_reg.es  = FP_SEG((void far *) mask);
  inreg.x.dx = FP_OFF((void far *) mask);
  inreg.x.ax = 0x09;
  inreg.x.bx = hotspot_x;
  inreg.x.cx = hotspot_y;
  inreg.x.dx = (unsigned) mask;
  int86x(0x33, &inreg, &inreg, &segment_reg);
}

#endif

/*
 ͻ
                          Define Mouse Text Cursor                         
 Ķ
                                                                           
   Function    :  Redefine appearance of mouse cursor in text mode.   If   
                  the hardware pointer is selected,  the screen and mask   
                  arguments are interpreted as the  beginning and ending   
                  scan lines for the mouse cursor. Further, the hardware   
                  cursor is limited to a block type cursor, and only the   
                  blocks width can be set. Example:                        
                                                                           
                       set_text_mouse(1, 0, 7)   // full block cursor      
                       set_text_mouse(1, 6, 7)   // underline cursor       
                                                                           
                  Note: The second and third arguments are used to define  
                  the block cursors width.  The ranges for the  arguments  
                  are Mono = 0-11, CGA = 0-7, EGA = 0-13, and VGA = 0-15.  
                                                                           
                  If the software cursor type is selected, the character   
                  and attribute at the mouse pointer is  ANDed  with the   
                  AND mask and then XORed with the XOR mask. Example:      
                                                                           
                       set_text_mouse(0, 0x77FF, 0x7700)                   
                                                                           
                  Note: The above software mouse cursor type results in a  
                  mouse cursor which inverts the foreground & background   
                  colours for the mouse pointer.                           
                                                                           
   Prototype   :  void set_text_mouse(int cursor_type, int cursor_screen,  
                                      int cursor_mask)                     
                                                                           
   Entry       :  type        = 0 for software pointer, or                 
                                1 for hardware pointer.                    
                                                                           
                  cursor_screen = defines cursor screen                    
                  cursor_mask   = defines cursor mask                      
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_TEXT_MOUSE

void set_text_mouse(int type, int cursor_screen, int cursor_mask)
{
  union REGS inreg;
  struct SREGS segment_reg;

  segment_reg.es  = FP_SEG((void far *) cursor_mask);
  inreg.x.dx = FP_OFF((void far *) cursor_mask);
  inreg.x.ax = 0x0A;
  inreg.x.bx = type;
  inreg.x.cx = cursor_screen;
  inreg.x.dx = cursor_mask;
  int86x(0x33, &inreg, &inreg, &segment_reg);
}

#endif

/*
 ͻ
                             Get Mouse Movement                            
 Ķ
                                                                           
   Function    :  Get the distance between the current mouse position and  
                  mouse position following last call to this function.     
                                                                           
                  The values returned are given in mickeys, where          
                  1 mickey = 1/200 inch.                                   
                                                                           
                  Values of mouse_x and mouse_y are interpreted as signed  
                  values.  Positive values indicate a downward motion, or  
                  movement to right of the screen border. Negative values  
                  indicate motion upward or to left border of the screen.  
                                                                           
   Prototype   :  void get_mouse_movement(int &mouse_x, int &mouse_y)      
                                                                           
   Entry       :  &mouse_x  =  horizontal count in mickeys                 
                  &mouse_y  =  vertical count in mickeys                   
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __GET_MOUSE_MOVEMENT

void get_mouse_movement(int &mouse_x, int &mouse_y)
{
  union REGS outreg;

  outreg.x.ax = 0x0B;
  int86(0x33, &outreg, &outreg);
  mouse_x = outreg.x.cx;
  mouse_y = outreg.x.dx;
}

#endif

/*
 ͻ
                          Set Mouse Event Handler                          
 Ķ
                                                                           
   Function    :  Set mouse event handler sets the  address of a custom    
                  mouse event handler called by the mouse driver when a    
                  specified mouse event occurs.                            
                                                                           
   Prototype   :  void set_mouse_handler(unsigned mask_event,              
                                         unsigned far &handler)            
                                                                           
   Entry       :  event_mask =                                             
                               bit 0 = mouse movement                      
                               bit 1 = left button press                   
                               bit 2 = left button release                 
                               bit 3 = right button press                  
                               bit 4 = right button release                
                               bit 5 = centre button press                 
                               bit 6 = centre button release               
                               bits 7 to 15 are unused                     
                                                                           
                  &handler   = address of your event handler               
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_HANDLER

void set_mouse_handler(int event_mask, int &handler)
{                                               //--> NOT TESTED * NOT TESTED
  union REGS inreg;                             //--> NOT TESTED * NOT TESTED
  struct SREGS segment_reg;                     //--> NOT TESTED * NOT TESTED
						//--> NOT TESTED * NOT TESTED
  segment_reg.es = FP_SEG((void far *) handler);//--> NOT TESTED * NOT TESTED
  inreg.x.dx = FP_OFF((void far *) handler);    //--> NOT TESTED * NOT TESTED
  inreg.x.ax = 0x0C;                            //--> NOT TESTED * NOT TESTED
  inreg.x.cx = (unsigned) event_mask;           //--> NOT TESTED * NOT TESTED
  inreg.x.dx = (unsigned) handler;              //--> NOT TESTED * NOT TESTED
  int86x(0x33, &inreg, &inreg, &segment_reg);   //--> NOT TESTED * NOT TESTED
}                                               //--> NOT TESTED * NOT TESTED

#endif

/*
 ͻ
                     Enable/Disable Light Pen Emulation                    
 Ķ
                                                                           
   Function    :  Enable/Disable light pen emulation. A value of 1 enables 
                  light pen emulation,  and  any  other value will disable 
                  light pen emulation.                                     
                                                                           
                  Enabling light pen emulation must be used with programs  
                  which support a light pen.  When enabled,  the position  
                  of the mouse cursor is directly related to a light pens  
                  position, and any  left or right  mouse button press is  
                  taken as pressing the light pen button.                  
                                                                           
   Prototype   :  void mouse_light_pen(int pen_on_off)                     
                                                                           
   Entry       :  pen_on_off   =   1      enable light pen emulation       
                  pen_on_off  NOT  1      disable light pen emulation      
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __MOUSE_LIGHT_PEN

void mouse_light_pen(int pen_on_off)           //--> NOT TESTED * NOT TESTED
{                                              //--> NOT TESTED * NOT TESTED
  union REGS inreg;                            //--> NOT TESTED * NOT TESTED
					       //--> NOT TESTED * NOT TESTED
  inreg.x.ax = pen_on_off == 1  ? 0x0D : 0x0E; //--> NOT TESTED * NOT TESTED
  int86(0x33, &inreg, &inreg);                 //--> NOT TESTED * NOT TESTED
}                                              //--> NOT TESTED * NOT TESTED

#endif

/*
 ͻ
                          Set Mouse Pointer Speed                          
 Ķ
                                                                           
   Function    :  Sets speed rate at which the mouse pointer moves about   
                  the screen. The speed is set in mickeys to pixel rate.   
                                                                           
   Prototype   :  void set_mouse_speed(int mouse_x, int mouse_y)           
                                                                           
   Entry       :  mouse_x = horiz mickeys (1-32767, default per 8 pixels)  
                  mouse_y = vert mickeys (1-32767, default per 16 pixels)  
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_SPEED

void set_mouse_speed(int mouse_x, int mouse_y)
{
  union REGS inreg;

  inreg.x.ax = 0x0F;
  inreg.x.cx = mouse_x;
  inreg.x.dx = mouse_y;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                 Set Mouse Pointer Boundary Exclusion Area                 
 Ķ
                                                                           
   Function    :  Set the mouse pointer boundary exculsion area where the  
                  mouse pointer will not be displayed.                     
                                                                           
   Notes       :  This area is undefined after a call to the detect_mouse  
                  function,  and can be defined at any time by using this  
                  function.                                                
                                                                           
                  The mouse driver can only control one exclusion area at  
                  a time.                                                  
                                                                           
                  (x, y) coordinates are virtual coordinate limits.        
                                                                           
   Prototype   :  void set_mouse_no_area(int left_x, int top_y,            
                                         int right_x, int bottom_y)        
                                                                           
   Entry       :  left_x   =  far left x coordinate of exclusion area      
                  top_y    =  top y coordinate of exclusion area           
                  right_x  =  far right x coordinate of exclusion area     
                  bottom_y =  bottom y coordinate of exclusion area        
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_NO_AREA

void set_mouse_no_area(int left_x, int top_y, int right_x, int bottom_y)
{
  union REGS inreg;

  inreg.x.ax = 0x10;
  inreg.x.cx = left_x;
  inreg.x.dx = top_y;
  inreg.x.si = right_x;
  inreg.x.di = bottom_y;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                     Set Mouse Speed Doubling Threshold                    
 Ķ
                                                                           
   Function    :  Sets maximum threshold for doubling the mouse pointer    
                  speed.  If the mouse moves quickly,  the mouse driver    
                  will double the motion of the mouse pointer.             
                                                                           
                  By default, the mouse moves 64 mickeys per second        
                  (about 1/3 of an inch).                                  
                                                                           
                  To avoid doubling the mouse speed, set the threshold     
                  to a large value like 1000.                              
                                                                           
   Prototype   :  void set_mouse_speed(int speed_limit)                    
                                                                           
   Entry       :  speed_limit = speed limit in mickeys per second          
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_THRESHOLD

void set_mouse_threshold(int speed_limit)
{
  union REGS inreg;

  inreg.x.ax = 0x13;
  inreg.x.dx = speed_limit;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                  Exchange User Defined Mouse Event Handler                
 Ķ
                                                                           
   Function    :  This function installs a custom mouse event handler and  
                  obtains the  address and event mask  of the  previously  
                  installed mouse event handler.                           
                                                                           
   Prototype   :  void swap_mouse_handler(int &new_mask, int &old_mask,    
                                          int far &handler)                
                                                                           
   Entry       :  new_mask =                                               
                               bit 0 = mouse movement                      
                               bit 1 = left button press                   
                               bit 2 = left button release                 
                               bit 3 = right button press                  
                               bit 4 = right button release                
                               bit 5 = centre button press                 
                               bit 6 = centre button release               
                               bits 7 to 15 are unused                     
                                                                           
                  &handler  =   far address of event handler               
                                                                           
   Return      :  &old_mask =   event mask of previous event handler       
                                                                           
                  &handler  =  far address of previous event handler       
                                                                           
 ͼ
*/

#if __SWAP_MOUSE_HANDLER

void swap_mouse_handler(int &new_mask, int &old_mask, int far &handler)
{
  union REGS inreg;                             //--> NOT TESTED * NOT TESTED
  struct SREGS segment_reg;			//--> NOT TESTED * NOT TESTED
						//--> NOT TESTED * NOT TESTED
  segment_reg.es = FP_SEG((void far *) handler);//--> NOT TESTED * NOT TESTED
  inreg.x.dx = FP_OFF((void far *) handler);    //--> NOT TESTED * NOT TESTED
  inreg.x.ax = 0x14;                            //--> NOT TESTED * NOT TESTED
  inreg.x.cx = new_mask;                        //--> NOT TESTED * NOT TESTED
  inreg.x.dx = handler;                         //--> NOT TESTED * NOT TESTED
  int86x(0x33, &inreg, &inreg, &segment_reg);   //--> NOT TESTED * NOT TESTED
  old_mask = inreg.x.cx;                        //--> NOT TESTED * NOT TESTED
  handler = inreg.x.dx;                         //--> NOT TESTED * NOT TESTED
}                                               //--> NOT TESTED * NOT TESTED

#endif

/*
 ͻ
                      Get Mouse Save Status Buffer Size                    
 Ķ
                                                                           
   Function    :  This function obtains the size of mouse status buffer    
                  with the current status of the mouse driver.             
                                                                           
   Prototype   :  int mouse_buffer_size(void)                              
                                                                           
   Entry       :  void                                                     
                                                                           
   Return      :  int  =  mouse status buffer size in bytes                
                                                                           
 ͼ
*/

#if __MOUSE_BUFFER_SIZE

int mouse_buffer_size(void)
{
  union REGS outreg;

  outreg.x.ax = 0x15;
  int86(0x33, &outreg, &outreg);
  return (outreg.x.bx);
}

#endif

/*
 ͻ
    Save/Restore Mouse Driver State or Set Alternate Mouse User Handler    
 Ķ
                                                                           
   Function    :  If save state requested, the status of the mouse driver  
                  is saved for future restoration.                         
                                                                           
                  If restore state requested, this function reads mouse    
                  driver status from the user buffer previously saved,     
                  and restores the mouse driver status.                    
                                                                           
                  Note: size of the mouse status buffer can be determined  
                        by calling mouse_buffer_size.                      
                                                                           
                  If set alternate mouse user handler requested, the func  
                  reads the mouse driver status from the user buffer that  
                  was previously saved with an int 33h function 16h call.  
                                                                           
   Prototype   :  void mouse_state(int save_restore_alternate,             
                                   int &buffer_state)                      
                                                                           
   Entry       :  save_restore  =  1   save mouse status buffer            
                                =  2   set alternate user handler          
                          NOT 1 or 2   restore mouse buffer state          
                                                                           
                  &buffer_state = address of mouse status buffer           
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __MOUSE_STATE

void mouse_state(int save_restore_alternate, int &buffer_state)
{
  union REGS inreg;                     //-------> NOT TESTED * NOT TESTED
  struct SREGS segment_reg;             //-------> NOT TESTED * NOT TESTED
					//-------> NOT TESTED * NOT TESTED
  segment_reg.es = FP_SEG((void far *) buffer_state);
  inreg.x.dx = FP_OFF((void far *) buffer_state);
  if (save_restore_alternate == 2) inreg.x.ax = 0x18;
  else inreg.x.ax = save_restore_alternate == 1 ? 0x16 : 0x17;
  inreg.x.dx = buffer_state;            //-------> NOT TESTED * NOT TESTED
  int86x(0x33, &inreg, &inreg, &segment_reg);
}                                       //-------> NOT TESTED * NOT TESTED

#endif

/*
 ͻ
                Get Address of Alternate Mouse Event Handler               
 Ķ
                                                                           
   Function    :  Obtains the address and mask of the alternate event      
                  handler which has been previously installed.             
                                                                           
   Prototype   :  int get_mouse_handler(int event_mask, int &handler)      
                                                                           
   Entry       :  event_mask =  event mask of event handler                
                                                                           
                  &handler   =  address of matching event handler          
                                                                           
   Return      :  int  =  event mask, or                                   
                       =  00h if no handler installed                      
                                                                           
 ͼ
*/

#if __GET_MOUSE_HANDLER

int get_mouse_handler(int event_mask, int &handler)
{
  union REGS inreg;                             //--> NOT TESTED * NOT TESTED
  struct SREGS segment_reg;                     //--> NOT TESTED * NOT TESTED
						//--> NOT TESTED * NOT TESTED
  segment_reg.es = FP_SEG((void far *) handler);//--> NOT TESTED * NOT TESTED
  inreg.x.dx = FP_OFF((void far *) handler);    //--> NOT TESTED * NOT TESTED
  inreg.x.ax = 0x19;                            //--> NOT TESTED * NOT TESTED
  inreg.x.cx = event_mask;                      //--> NOT TESTED * NOT TESTED
  int86x(0x33, &inreg, &inreg, &segment_reg);   //--> NOT TESTED * NOT TESTED
  handler = inreg.x.dx;                         //--> NOT TESTED * NOT TESTED
  return (inreg.x.cx);                          //--> NOT TESTED * NOT TESTED
}                                               //--> NOT TESTED * NOT TESTED

#endif

/*
 ͻ
                           Set Mouse Sensitivity                           
 Ķ
                                                                           
   Function    :  This function combines the sensitivity for horizontal    
                  and vertical motion and the threshold for doubling the   
                  mouse pointer speed on the screen.                       
                                                                           
   Prototype   :  void set_mouse_touch(int mouse_x, int mouse_y,           
                                       int threshold)                      
                                                                           
   Entry       :  mouse_x   = horiz rate in mickeys per pixel (1-32767)    
                  mouse_y   = vert rate in mickeys per pixel (1-32767)     
                  threshold = double speed threshold in mickeys per second 
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_TOUCH

void set_mouse_touch(int mouse_x, int mouse_y, int threshold)
{
  union REGS inreg;

  inreg.x.ax = 0x1A;
  inreg.x.bx = mouse_x;
  inreg.x.cx = mouse_y;
  inreg.x.dx = threshold;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                           Get Mouse Sensitivity                           
 Ķ
                                                                           
   Function    :  This function obtains the current relationship between   
                  the mouse motion,  pointer motion,  and threshold  for   
                  doubling the mouse speed.                                
                                                                           
   Prototype   :  void get_mouse_touch(int &mouse_x, int &mouse_y,         
                                         int &threshold)                   
                                                                           
   Entry       :  mouse_x   = horiz rate in mickeys per pixel (1-32767)    
                  mouse_y   = vert rate in mickeys per pixel (1-32767)     
                  threshold = double speed threshold in mickeys per second 
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __GET_MOUSE_TOUCH

void get_mouse_touch(int &mouse_x, int &mouse_y, int &threshold)
{
  union REGS outreg;

  outreg.x.ax = 0x1B;
  int86(0x33, &outreg, &outreg);
  mouse_x = outreg.x.bx;
  mouse_y = outreg.x.cx;
  threshold = outreg.x.dx;
}

#endif

/*
 ͻ
                      Set Mouse Hardware Interrupt Rate                    
 Ķ
                                                                           
   Function    :  Sets rate at which mouse hardware produces interrupts    
                  for the mouse driver for the current mouse position and  
                  mouse button status.                                     
                                                                           
                  This function is only relevant to the Inport Mouse.      
                                                                           
                  If more than one bit is set in the ax register, the      
                  mouse driver takes the least significant bit only into   
                  consideration.                                           
                                                                           
   Prototype   :  void set_mouse_int_rate(int interrupt_rate)              
                                                                           
   Entry       :  interrupt_rate = if following bit set:                   
                                   bit 0   = none                          
                                   bit 1   = 30  interrupts per second     
                                   bit 2   = 50  interrupts per second     
                                   bit 4   = 100 interrupts per second     
                                   bits 5 to 15 unused                     
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_INT_RATE

// USE OF THIS FUNCTION IS HIGHLY UNLIKELY - INCLUDED FOR COMPLETION ONLY
void set_mouse_int_rate(int interrupt_rate)
{                               //-----------> NOT TESTED * NOT TESTED
  union REGS inreg;             //-----------> NOT TESTED * NOT TESTED
				//-----------> NOT TESTED * NOT TESTED
  inreg.x.ax = 0x1C;            //-----------> NOT TESTED * NOT TESTED
  inreg.x.bx = interrupt_rate;	//-----------> NOT TESTED * NOT TESTED
  int86(0x33, &inreg, &inreg);  //-----------> NOT TESTED * NOT TESTED
}

#endif

/*
 ͻ
                           Set Mouse Display Page                          
 Ķ
                                                                           
   Function    :  Set display page on which mouse pointer should appear.   
                                                                           
                  If set_mouse_no_area called to activate a display page,  
                  it will automatically adapt to the change, and you will  
                  not need to call this function.                          
                                                                           
   Prototype   :  void set_mouse_page(int page)                            
                                                                           
   Entry       :  page = desired display page (default page is 0)          
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __SET_MOUSE_PAGE

void set_mouse_page(int page)
{
  union REGS inreg;

  inreg.x.ax = 0x1D;
  inreg.x.bx = page;
  int86(0x33, &inreg, &inreg);
}

#endif

/*
 ͻ
                           Get Mouse Display Page                          
 Ķ
                                                                           
   Function    :  Get current display page for mouse pointer.              
                                                                           
   Prototype   :  int get_mouse_page(void)                                 
                                                                           
   Entry       :  void                                                     
                                                                           
   Return      :  int  =  current display page                             
                                                                           
 ͼ
*/

#if __GET_MOUSE_PAGE

int get_mouse_page(void)
{
  union REGS outreg;

  outreg.x.ax = 0x1E;
  int86(0x33, &outreg, &outreg);
  return (outreg.x.bx);
}

#endif

/*
 ͻ
                            Disable Mouse Driver                           
 Ķ
                                                                           
   Function    :  De-activates the mouse driver and releases the address   
                  of the previous interrupt handlers, other than INT 33h   
                  and INT 10h function  71h (for 8086),  or function 74h   
                  (for 80286/80386 - cannot confirm for 80486+).           
                                                                           
                  The original application  will be able to  restore  the  
                  original contents of the  interrupt vector  of  INT 33h  
                  using the address in the register pair es:bx. This will  
                  effectively eliminate all mouse support.                 
                                                                           
   Prototype   :  void disable_mouse(int &error_status, int &handler)      
                                                                           
   Entry       :  error_status  = 0x001F  if function successful           
                                = 0xFFFF  if function unsuccessful         
                                                                           
                  &handler      = address of previous handler of INT 33h   
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __DISABLE_MOUSE

void disable_mouse(int &error_status, int &handler)
{
  union REGS outreg;                            //--> NOT TESTED * NOT TESTED
  struct SREGS segment_reg;                     //--> NOT TESTED * NOT TESTED
						//--> NOT TESTED * NOT TESTED
  segment_reg.es = FP_SEG((void far *) handler);//--> NOT TESTED * NOT TESTED
  outreg.x.dx = FP_OFF((void far *) handler);   //--> NOT TESTED * NOT TESTED
  outreg.x.ax = 0x1F;                           //--> NOT TESTED * NOT TESTED
  int86x(0x33, &outreg, &outreg, &segment_reg); //--> NOT TESTED * NOT TESTED
  error_status = outreg.x.ax;                   //--> NOT TESTED * NOT TESTED
  handler = outreg.x.bx;                        //--> NOT TESTED * NOT TESTED
}

#endif

/*
 ͻ
                            Enable Mouse Driver                            
 Ķ
                                                                           
   Function    :  Activates the mouse driver and resets all the interrupts 
                  previously removed with disable_mouse() function.        
                                                                           
   Prototype   :  void enable_mouse(void)                                  
                                                                           
   Entry       :  void                                                     
                                                                           
   Return      :  void                                                     
                                                                           
 ͼ
*/

#if __ENABLE_MOUSE

void enable_mouse(void)
{
  union REGS inreg;                             //--> NOT TESTED * NOT TESTED
						//--> NOT TESTED * NOT TESTED
  inreg.x.ax = 0x20;                            //--> NOT TESTED * NOT TESTED
  int86(0x33, &inreg, &inreg);                  //--> NOT TESTED * NOT TESTED
}

#endif

/*
 ͻ
                         Mouse Driver Software Reset                       
 Ķ
                                                                           
   Function    :  Reset the mouse driver and set all internal variables    
                  to default values,  remove mouse pointer from screen,    
                  and disable current mouse event handler.                 
                                                                           
                  Note:  this function is identical to the detect_mouse()  
                  function with the exception that it does not initialize  
                  the mouse hardware.                                      
                                                                           
   Prototype   :  void reset_mouse(void)                                   
                                                                           
   Entry       :  void                                                     
                                                                           
   Return      :  int  =  2  if mouse driver installed else returns 0      
                                                                           
                  Note:  ax  =  0x0021  if mouse driver not installed      
                             =  0xFFFF  if mouse driver installed          
                                                                           
 ͼ
*/

#if __RESET_MOUSE

int reset_mouse(void)
{
  union REGS outreg;

  outreg.x.ax = 0x21;
  int86(0x33, &outreg, &outreg);
  return (outreg.x.ax ? outreg.x.bx : 0);
}

#endif

/*
 ͻ
  ATTENTION:---> Undefine Conditional Compilation Directives <--:ATTENTION 
 ͼ
*/

#undef __DETECT_MOUSE
#undef __MOUSE_SWITCH
#undef __GET_MOUSE_XY
#undef __SET_MOUSE_XY
#undef __GET_MOUSE_PRESS
#undef __GET_MOUSE_RELEASE
#undef __SET_MOUSE_RANGE
#undef __SET_GRAPHIC_MOUSE
#undef __SET_TEXT_MOUSE
#undef __GET_MOUSE_MOVEMENT
#undef __SET_MOUSE_HANDLER
#undef __MOUSE_LIGHT_PEN
#undef __SET_MOUSE_SPEED
#undef __SET_MOUSE_NO_AREA
#undef __SET_MOUSE_THRESHOLD
#undef __SWAP_MOUSE_HANDLER
#undef __MOUSE_BUFFER_SIZE
#undef __MOUSE_STATE
#undef __GET_MOUSE_HANDLER
#undef __SET_MOUSE_TOUCH
#undef __GET_MOUSE_TOUCH
#undef __SET_MOUSE_INT_RATE
#undef __SET_MOUSE_PAGE
#undef __GET_MOUSE_PAGE
#undef __DISABLE_MOUSE
#undef __ENABLE_MOUSE
#undef __RESET_MOUSE

/*
 ͻ
                               Source Code Ends                            
 ͼ
*/
